/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.utils.dialog;

import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.utils.VWHelp;
import filenet.vw.toolkit.utils.VWPrinter;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.dialog.VWModalDialog;
import filenet.vw.toolkit.utils.mapui.VWMapAttribs;
import filenet.vw.toolkit.utils.resources.VWResource;
import filenet.vw.toolkit.utils.uicontrols.border.VWTitledBorder;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.print.PageFormat;
import java.awt.print.PrinterJob;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class VWPrintSetupDialog
extends VWModalDialog
implements ActionListener,
Runnable {
    private JCheckBox m_printMapCkBox = null;
    private ButtonGroup m_mapButtonGroup = null;
    private JRadioButton m_currentMapRadioButton = null;
    private JRadioButton m_allMapsRadioButton = null;
    private JCheckBox m_printWflPropsCkBox = null;
    private JCheckBox m_printStepRoutePropsCkBox = null;
    private JCheckBox m_printTextAnnotationPropsCkBox = null;
    private JButton m_okButton = null;
    private JButton m_cancelButton = null;
    private JButton m_pageSetupButton = null;
    private JButton m_helpButton = null;
    protected PrinterJob m_printerJob = null;
    protected PageFormat m_pageFormat = null;
    protected VWMapAttribs m_mapAttribs = null;

    public VWPrintSetupDialog(VWPrinter vwPrinter) {
        super(vwPrinter.getParentFrame());
        this.m_printerJob = vwPrinter.getPrinterJob();
        this.m_pageFormat = vwPrinter.getPageFormat();
        Dimension dim = VWStringUtils.stringToDimension("385,335");
        if (dim == null) {
            dim = new Dimension(360, 235);
        }
        this.setSize(dim);
        this.setTitle(VWResource.s_printSetup);
        this.getContentPane().setLayout(new GridBagLayout());
        GridBagConstraints gbConst = new GridBagConstraints();
        gbConst.gridx = 0;
        gbConst.gridy = 0;
        gbConst.anchor = 23;
        gbConst.gridwidth = 1;
        gbConst.gridheight = 1;
        gbConst.fill = 2;
        gbConst.weightx = 1.0;
        gbConst.weighty = 0.0;
        gbConst.insets = new Insets(5, 5, 0, 5);
        this.getContentPane().add((Component)this.createMapOptionsPanel(), gbConst);
        ++gbConst.gridy;
        gbConst.fill = 1;
        gbConst.weighty = 1.0;
        gbConst.insets = new Insets(0, 5, 0, 5);
        this.getContentPane().add((Component)this.createPropertyOptionsPanel(), gbConst);
        ++gbConst.gridy;
        gbConst.fill = 2;
        gbConst.weighty = 0.0;
        gbConst.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.createButtonControlPanel(true), gbConst);
    }

    public void init(VWMapAttribs mapAttribs) {
        this.m_mapAttribs = mapAttribs;
        this.m_printMapCkBox.setSelected(this.m_mapAttribs.isPrintMap());
        this.m_currentMapRadioButton.setSelected(!this.m_mapAttribs.isPrintAll());
        this.m_currentMapRadioButton.setEnabled(this.m_printMapCkBox.isSelected());
        this.m_allMapsRadioButton.setSelected(this.m_mapAttribs.isPrintAll());
        this.m_allMapsRadioButton.setEnabled(this.m_printMapCkBox.isSelected());
        this.m_printWflPropsCkBox.setSelected(this.m_mapAttribs.isPrintWflProperty());
        this.m_printStepRoutePropsCkBox.setSelected(this.m_mapAttribs.isPrintStepRouteProperty());
        this.m_printTextAnnotationPropsCkBox.setSelected(this.m_mapAttribs.isPrintTextAnnotationProperties());
    }

    public PageFormat getPageFormat() {
        return this.m_pageFormat;
    }

    public int returnStatus() {
        return this.m_nExitStatus;
    }

    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        if (source.equals(this.m_printMapCkBox)) {
            this.m_currentMapRadioButton.setEnabled(this.m_printMapCkBox.isSelected());
            this.m_allMapsRadioButton.setEnabled(this.m_printMapCkBox.isSelected());
        } else if (source.equals(this.m_okButton)) {
            this.onOKButton(event);
        } else if (source.equals(this.m_cancelButton)) {
            this.onCancelButton(event);
        } else if (source.equals(this.m_pageSetupButton)) {
            this.onPageSetupButton(event);
        } else if (source.equals(this.m_helpButton)) {
            VWHelp.displayPage(VWHelp.Help_General + "bpfwd054.htm");
        } else {
            JButton defaultButton = this.getRootPane().getDefaultButton();
            defaultButton.doClick();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        try {
            block4: {
                try {
                    if (this.m_printerJob == null) break block4;
                    this.m_pageFormat = this.m_printerJob.pageDialog(this.m_pageFormat);
                    if (this.m_pageFormat == null) break block4;
                    this.m_printerJob.validatePage(this.m_pageFormat);
                }
                catch (Exception ex) {
                    VWDebug.logException(ex);
                    Object var3_2 = null;
                    this.setEnabled(true);
                    this.toFront();
                    return;
                }
            }
            Object var3_1 = null;
            this.setEnabled(true);
            this.toFront();
            return;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.setEnabled(true);
            this.toFront();
            throw throwable;
        }
    }

    private JPanel createMapOptionsPanel() {
        try {
            JPanel panel = new JPanel(new GridBagLayout());
            panel.setBorder(new VWTitledBorder(VWResource.s_maps));
            GridBagConstraints gbConst = new GridBagConstraints();
            gbConst.gridx = 0;
            gbConst.gridy = 0;
            gbConst.fill = 2;
            gbConst.weightx = 1.0;
            gbConst.weighty = 0.0;
            gbConst.anchor = 23;
            gbConst.gridwidth = 0;
            gbConst.gridheight = 1;
            gbConst.insets = new Insets(0, 15, 0, 5);
            this.m_printMapCkBox = new JCheckBox(VWResource.s_printWorkflowMap);
            this.m_printMapCkBox.addActionListener(this);
            panel.add((Component)this.m_printMapCkBox, gbConst);
            ++gbConst.gridy;
            gbConst.insets = new Insets(0, 35, 0, 5);
            this.m_mapButtonGroup = new ButtonGroup();
            this.m_currentMapRadioButton = new JRadioButton(VWResource.s_currentMap);
            this.m_mapButtonGroup.add(this.m_currentMapRadioButton);
            panel.add((Component)this.m_currentMapRadioButton, gbConst);
            ++gbConst.gridy;
            this.m_allMapsRadioButton = new JRadioButton(VWResource.s_allMaps);
            this.m_mapButtonGroup.add(this.m_allMapsRadioButton);
            panel.add((Component)this.m_allMapsRadioButton, gbConst);
            return panel;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }

    private JPanel createPropertyOptionsPanel() {
        try {
            JPanel panel = new JPanel(new GridBagLayout());
            panel.setBorder(new VWTitledBorder(VWResource.s_properties));
            GridBagConstraints gbConst = new GridBagConstraints();
            gbConst.gridx = 0;
            gbConst.gridy = 0;
            gbConst.fill = 2;
            gbConst.weightx = 1.0;
            gbConst.weighty = 0.0;
            gbConst.anchor = 23;
            gbConst.gridwidth = 0;
            gbConst.gridheight = 1;
            gbConst.insets = new Insets(0, 15, 0, 5);
            this.m_printWflPropsCkBox = new JCheckBox(VWResource.s_printWorkflowProperties);
            panel.add((Component)this.m_printWflPropsCkBox, gbConst);
            ++gbConst.gridy;
            this.m_printStepRoutePropsCkBox = new JCheckBox(VWResource.s_printStepRouteProperties);
            panel.add((Component)this.m_printStepRoutePropsCkBox, gbConst);
            ++gbConst.gridy;
            this.m_printTextAnnotationPropsCkBox = new JCheckBox(VWResource.s_printTextAnnotationProperties);
            panel.add((Component)this.m_printTextAnnotationPropsCkBox, gbConst);
            ++gbConst.gridy;
            gbConst.fill = 1;
            gbConst.weighty = 1.0;
            panel.add((Component)new JLabel(" "), gbConst);
            return panel;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }

    private JPanel createButtonControlPanel(boolean bShowAdvanced) {
        try {
            JPanel panel = new JPanel();
            panel.setLayout(new FlowLayout());
            this.m_okButton = new JButton(VWResource.s_ok);
            this.m_okButton.setSelected(true);
            this.m_okButton.addActionListener(this);
            panel.add(this.m_okButton);
            this.m_cancelButton = new JButton(VWResource.s_cancel);
            this.m_cancelButton.addActionListener(this);
            panel.add(this.m_cancelButton);
            this.m_pageSetupButton = new JButton(VWResource.s_pageSetup);
            this.m_pageSetupButton.addActionListener(this);
            panel.add(this.m_pageSetupButton);
            this.m_helpButton = new JButton(VWResource.s_help);
            this.m_helpButton.addActionListener(this);
            panel.add(this.m_helpButton);
            this.getRootPane().setDefaultButton(this.m_okButton);
            return panel;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }

    private void onOKButton(ActionEvent event) {
        try {
            if (!(this.m_printMapCkBox.isSelected() || this.m_printWflPropsCkBox.isSelected() || this.m_printStepRoutePropsCkBox.isSelected() || this.m_printTextAnnotationPropsCkBox.isSelected())) {
                JOptionPane.showMessageDialog(this.m_parent, VWResource.s_printSetupError, VWResource.s_printSetup, 0);
            } else {
                this.m_mapAttribs.setPrintMap(this.m_printMapCkBox.isSelected());
                this.m_mapAttribs.setPrintAll(this.m_allMapsRadioButton.isSelected());
                this.m_mapAttribs.setPrintWflProperty(this.m_printWflPropsCkBox.isSelected());
                this.m_mapAttribs.setPrintStepRouteProperty(this.m_printStepRoutePropsCkBox.isSelected());
                this.m_mapAttribs.setPrintTextAnnotationProperties(this.m_printTextAnnotationPropsCkBox.isSelected());
                this.m_nExitStatus = 0;
                this.setVisible(false);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            JOptionPane.showMessageDialog(this.m_parent, ex.getLocalizedMessage());
        }
    }

    private void onCancelButton(ActionEvent event) {
        try {
            this.m_nExitStatus = 1;
            this.setVisible(false);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void onPageSetupButton(ActionEvent event) {
        try {
            Thread pThread = new Thread((Runnable)this, "Wfl print setup thread");
            pThread.start();
            this.setEnabled(false);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }
}

